#ifndef __CCLINK_APS_ERROR_H
#define __CCLINK_APS_ERROR_H

/////////////////////////////////////////////////////////////////////////////////////
// CC-Link Slave Application Task
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_CCLINK_APS_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command received.
//
#define TLR_E_CCLINK_APS_COMMAND_INVALID ((TLR_RESULT)0xC06B0001L)

//
// MessageId: TLR_I_CCLINK_APS_OPEN_DBM_FILE
//
// MessageText:
//
//  Failed to open configuration database.
//
#define TLR_I_CCLINK_APS_OPEN_DBM_FILE   ((TLR_RESULT)0x406B0002L)

//
// MessageId: TLR_E_CCLINK_APS_DATASET
//
// MessageText:
//
//  Failed to open configuration dataset.
//
#define TLR_E_CCLINK_APS_DATASET         ((TLR_RESULT)0xC06B0003L)

//
// MessageId: TLR_E_CCLINK_APS_TABLE_GLOBAL
//
// MessageText:
//
//  Failed to open GLOBAL configuration dataset.
//
#define TLR_E_CCLINK_APS_TABLE_GLOBAL    ((TLR_RESULT)0xC06B0004L)

//
// MessageId: TLR_E_CCLINK_APS_TABLE_CCLS_INI
//
// MessageText:
//
//  Failed to open CCLS_INI configuration dataset.
//
#define TLR_E_CCLINK_APS_TABLE_CCLS_INI  ((TLR_RESULT)0xC06B0005L)

//
// MessageId: TLR_E_CCLINK_APS_WATCHDOG_PARAMETER
//
// MessageText:
//
//  Invalid parameter for watchdog supervision.
//
#define TLR_E_CCLINK_APS_WATCHDOG_PARAMETER ((TLR_RESULT)0xC06B0006L)

//
// MessageId: TLR_E_CCLINK_APS_SIZE_TABLE_CCLS_INI
//
// MessageText:
//
//  Invalid size of CCLS_INI configuration dataset.
//
#define TLR_E_CCLINK_APS_SIZE_TABLE_CCLS_INI ((TLR_RESULT)0xC06B0007L)

//
// MessageId: TLR_E_CCLINK_APS_PACKET_LENGTH
//
// MessageText:
//
//  Invalid packet length.
//
#define TLR_E_CCLINK_APS_PACKET_LENGTH   ((TLR_RESULT)0xC06B0008L)

//
// MessageId: TLR_I_CCLINK_APS_CONFIG_LOCK
//
// MessageText:
//
//  Configuration is locked.
//
#define TLR_I_CCLINK_APS_CONFIG_LOCK     ((TLR_RESULT)0x406B0009L)

//
// MessageId: TLR_E_CCLINK_APS_DATABASE_FOUND
//
// MessageText:
//
//  Configuration database found.
//
#define TLR_E_CCLINK_APS_DATABASE_FOUND  ((TLR_RESULT)0xC06B000AL)

//
// MessageId: TLR_E_CCLINK_APS_SLAVE_STATION_ADDR_PARAMETER
//
// MessageText:
//
//  Invalid parameter for slave station address.
//
#define TLR_E_CCLINK_APS_SLAVE_STATION_ADDR_PARAMETER ((TLR_RESULT)0xC06B000BL)

//
// MessageId: TLR_E_CCLINK_APS_BAUDRATE_PARAMETER
//
// MessageText:
//
//  Invalid parameter for baudrate.
//
#define TLR_E_CCLINK_APS_BAUDRATE_PARAMETER ((TLR_RESULT)0xC06B000CL)

//
// MessageId: TLR_E_CCLINK_APS_NO_STATION_PARAMETER
//
// MessageText:
//
//  Invalid parameter for number of stations.
//
#define TLR_E_CCLINK_APS_NO_STATION_PARAMETER ((TLR_RESULT)0xC06B000DL)

//
// MessageId: TLR_E_CCLINK_APS_MODE_PARAMETER
//
// MessageText:
//
//  Invalid parameter for mode.
//
#define TLR_E_CCLINK_APS_MODE_PARAMETER  ((TLR_RESULT)0xC06B000EL)

//
// MessageId: TLR_E_CCLINK_APS_VENDOR_CODE_PARAMETER
//
// MessageText:
//
//  Invalid parameter for vendor code.
//
#define TLR_E_CCLINK_APS_VENDOR_CODE_PARAMETER ((TLR_RESULT)0xC06B000FL)

//
// MessageId: TLR_E_CCLINK_APS_MODEL_CODE_PARAMETER
//
// MessageText:
//
//  Invalid parameter for model code.
//
#define TLR_E_CCLINK_APS_MODEL_CODE_PARAMETER ((TLR_RESULT)0xC06B0010L)

//
// MessageId: TLR_E_CCLINK_APS_SW_VERSION_PARAMETER
//
// MessageText:
//
//  Invalid parameter for software version.
//
#define TLR_E_CCLINK_APS_SW_VERSION_PARAMETER ((TLR_RESULT)0xC06B0011L)

//
// MessageId: TLR_E_CCLINK_APS_MODEL_TYPE_PARAMETER
//
// MessageText:
//
//  Invalid parameter for model type.
//
#define TLR_E_CCLINK_APS_MODEL_TYPE_PARAMETER ((TLR_RESULT)0xC06B0012L)

//
// MessageId: TLR_E_CCLINK_APS_IO_MODE_PARAMETER
//
// MessageText:
//
//  Invalid parameter for IO mode.
//
#define TLR_E_CCLINK_APS_IO_MODE_PARAMETER ((TLR_RESULT)0xC06B0013L)

//
// MessageId: TLR_E_CCLINK_APS_REQUEST_RUNNING
//
// MessageText:
//
//  Request already running.
//
#define TLR_E_CCLINK_APS_REQUEST_RUNNING ((TLR_RESULT)0xC06B0014L)

//
// MessageId: TLR_E_CCLINK_APS_INVALD_STATE
//
// MessageText:
//
//  Request not allowed in current state.
//
#define TLR_E_CCLINK_APS_INVALD_STATE    ((TLR_RESULT)0xC06B0015L)

//
// MessageId: TLR_E_CCLINK_APS_PARAM_CYCLETIME
//
// MessageText:
//
//  Invalid parameter for cycletime.
//
#define TLR_E_CCLINK_APS_PARAM_CYCLETIME ((TLR_RESULT)0xC06B0016L)

//
// MessageId: TLR_E_CCLINK_APS_PARAM_CHN_INSTANCE
//
// MessageText:
//
//  Invalid parameter for DPM instance.
//
#define TLR_E_CCLINK_APS_PARAM_CHN_INSTANCE ((TLR_RESULT)0xC06B0017L)

//
// MessageId: TLR_E_CCLINK_APS_SET_SWITCH_CHANGE_NOT_ALLOWED
//
// MessageText:
//
//  Change switch state not allowed.
//
#define TLR_E_CCLINK_APS_SET_SWITCH_CHANGE_NOT_ALLOWED ((TLR_RESULT)0xC06B0018L)

//
// MessageId: TLR_E_CCLINK_APS_CCLINK_VERSION_PARAMETER
//
// MessageText:
//
//  Invalid parameter for CC-Link version.
//
#define TLR_E_CCLINK_APS_CCLINK_VERSION_PARAMETER ((TLR_RESULT)0xC06B0019L)

//
// MessageId: TLR_E_CCLINK_APS_STATION_TYPE_PARAMETER
//
// MessageText:
//
//  Invalid parameter for station type.
//
#define TLR_E_CCLINK_APS_STATION_TYPE_PARAMETER ((TLR_RESULT)0xC06B001AL)

//
// MessageId: TLR_E_CCLINK_APS_STATION_ADDR_WITH_NO_STATIONS_PARAMETER
//
// MessageText:
//
//  Invalid parameter for station address in combination with number of stations.
//
#define TLR_E_CCLINK_APS_STATION_ADDR_WITH_NO_STATIONS_PARAMETER ((TLR_RESULT)0xC06B001BL)

//
// MessageId: TLR_E_CCLINK_APS_EXTENSION_CYCLE_PARAMETER
//
// MessageText:
//
//  Invalid parameter extension cycle.
//
#define TLR_E_CCLINK_APS_EXTENSION_CYCLE_PARAMETER ((TLR_RESULT)0xC06B001CL)

//
// MessageId: TLR_E_CCLINK_APS_STATION_TYPE_WITH_CCLINK_VERSION_PARAMETER
//
// MessageText:
//
//  Invalid parameter for station type in combination with CC-Link version.
//
#define TLR_E_CCLINK_APS_STATION_TYPE_WITH_CCLINK_VERSION_PARAMETER ((TLR_RESULT)0xC06B001DL)

//
// MessageId: TLR_E_CCLINK_APS_PARAM_QUEUE_ELEMENT
//
// MessageText:
//
//  Invalid parameter for number of queue elements.
//
#define TLR_E_CCLINK_APS_PARAM_QUEUE_ELEMENT ((TLR_RESULT)0xC06B001EL)

//
// MessageId: TLR_E_CCLINK_APS_PARAM_POOL_ELEMENT
//
// MessageText:
//
//  Invalid parameter for number of pool elements.
//
#define TLR_E_CCLINK_APS_PARAM_POOL_ELEMENT ((TLR_RESULT)0xC06B001FL)

//
// MessageId: TLR_E_CCLINK_APS_PARAM_SWITCH
//
// MessageText:
//
//  Invalid parameter for switch parameter.
//
#define TLR_E_CCLINK_APS_PARAM_SWITCH    ((TLR_RESULT)0xC06B0020L)

//
// MessageId: TLR_E_CCLINK_APS_PARAM_IO_TYPES_POINTS
//
// MessageText:
//
//  Invalid parameter for number of I/O types and I/O points.
//
#define TLR_E_CCLINK_APS_PARAM_IO_TYPES_POINTS ((TLR_RESULT)0xC06B0021L)




#endif  //__CCLINK_APS_ERROR_H

